//-------------//
// MENU SCRIPT //
//-------------//

// Updated: 03/01/08
// Created: 08/20/07

// Create the menu class

function Menu(x, y, w)
{
	if (this instanceof Menu == false) return new Menu();
	
	this.x = x; this.y = y; this.w = w;
	this.items = []; // the item array... "new", "options", "etc..."
	this.window = window;
	this.font = font;
	this.onCancel = function(){};
	this.cancelable = true;
	this.openHeight = 0;
	this.BG = GrabImage(0, 0, SW, SH);
	this.preRender = undefined;
	this.postRender = undefined;
	this.CI = 0;
	this.height = this.font.getHeight() + 2;
	this.arrow = new MArrow('Arrow.png',this.x,this.y+(this.height/2)-4);
	this.maxHeight = null;
}

// Create function that appends a new choice

Menu.prototype.appendChoice = function(name, call, colorup, colordown, image)
{
	// Create a temporary object:
	var tempItem = {};
	tempItem.name = name;
	tempItem.call = call;
	tempItem.colorup = colorup;
	tempItem.colordown = colordown;
	tempItem.img = image;
	// And add the it to the array:
	this.items.push(tempItem);
}

// Create function that draws the menu

Menu.prototype.draw = function()
{
	// Create temporary variables:
	SetFrameRate(60);
	if(IsMapEngineRunning()) { UpdateMapEngine(); RenderMap(); }
	this.BG = GrabImage(0, 0, SW, SH);
	var active = true;
	// set the height
	if (this.maxHeight == null) this.maxHeight = this.items.length;
	var h = this.maxHeight*this.height;
	
	// Open the menu
	this.open(500);
	
	// Start the loop:
	ClearKeyQueue();
	while(active)
	{
		with(this)
		{
			if(preRender != undefined) preRender();
			else if(IsMapEngineRunning()) { UpdateMapEngine(); RenderMap(); }
			window.drawWindow(x,y,w,h);
			for (var i = 0; i < items.length; ++i)
			{
				if (CI == i && arrow.y == arrow.newY) font.setColorMask(items[i].colordown);
				else font.setColorMask(items[i].colorup);
				if (items[i].img != undefined)
				{
					font.drawText(x+12,y+i*height+height/2-font.getHeight()/2,items[i].name);
					items[i].img.blit(x+font.getStringWidth(items[i].name)+16, y+i*height);
				}
				else font.drawText(x+12,y+i*height,items[i].name);
			}
			arrow.blit();
		
			FlipScreen();
		
			// Handle keyboard input:
			while(AreKeysLeft())
			{
				switch(GetKey())
				{
					case KEY_UP:
						if (CI > 0) {CI--; arrow.newY -= height;}
					break;
					case KEY_DOWN:
						if (CI < items.length-1) {CI++; arrow.newY += height;}
					break;
					//case KEY_ENTER:
					case KEY_CTRL:
					case KEY_SPACE:
					case KEY_ENTER:
						close(500);
						if(this.postRender != undefined) this.postRender();	
						items[CI].call();
						return;
					break;
					case KEY_SHIFT:
					case KEY_ESCAPE:
						if(cancelable)
						{
							close(500);
							if(this.postRender != undefined) this.postRender();
							onCancel();
							active = false; // turns menu off
						}
					break;
				}
			}
		}
	}
}

// Create function that opens the menu:
Menu.prototype.open = function(ms)
{
	var time = GetTime();
	with(this)
	{
		var h = maxHeight*height;
		while (GetTime() - time < ms)
		{
			var i = (GetTime() - time) * h / ms;
			if(preRender != undefined) preRender();
			else BG.blit(0,0);
			window.drawWindow(x,y+h/2-i/2,w,i);
			FlipScreen();
		}
	}
}

// Create function that closes the menu
Menu.prototype.close = function(ms)
{
	var time = GetTime();
	with(this)
	{
		var h = maxHeight*height;
		while (GetTime() - time < ms)
		{
			var i = h - (GetTime() - time) * h / ms;
			if(preRender != undefined) preRender();
			else BG.blit(0,0);
			window.drawWindow(x,y+h/2-i/2,w,i);
			FlipScreen();
		}
	}
}

Menu.prototype.setHeight = function(h)
{
	this.height = h;
	this.arrow.y = this.y + (this.height/2) - 4;
	this.arrow.newY = this.arrow.y;
}

Menu.prototype.setMaxHeight = function(h)
{
	this.maxHeight = h;
}

// Create an Arrow Object
function MArrow(img,x,y)
{
	this.img = LoadImage(img);
	this.x = x;
	this.y = y;
	this.newX = x;
	this.newY = y;
}

MArrow.prototype.blit = function()
{
	with(this)
	{
		var nx = newX - x;
		var ny = newY - y;
		update();
		Line(x+img.width/2,y+img.height/2,x+img.width/2+nx,y+img.height/2+ny,Black);
		Line(x+img.width/2+1,y+img.height/2,x+img.width/2+nx+1,y+img.height/2+ny,Black);
		img.blit(x,y);
	}
}

MArrow.prototype.update = function()
{
	with(this)
	{
		if (newX > x) x++;
		if (newY > y) y++;
		if (newX < x) x--;
		if (newY < y) y--;
	}
}

function ClearKeyQueue()
{
	while(AreKeysLeft()) {GetKey();}
}